var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-classes-per-file class-name */
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer } from '../../../../utils';
import { isNumber, validate } from '../../../../utils/validate';
/**
 * Set the line width in the graphics state
 */
var w = /** @class */ (function (_super) {
    __extends(w, _super);
    function w(lineWidth) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.lineWidth + " w\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(lineWidth, isNumber, 'w operator arg "lineWidth" must be a number.');
        _this.lineWidth = lineWidth;
        return _this;
    }
    w.of = function (lineWidth) { return new w(lineWidth); };
    return w;
}(PDFOperator));
export default w;
