var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-classes-per-file class-name */
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer } from '../../../../utils';
import { isNumber, validateArr } from '../../../../utils/validate';
/**
 * Append a cubic Bézier curve to the current path.
 * The curve shall extend from the current point to the point (x3, y3),
 *   using (x1, y1) and (x2, y2) as the Bézier control points.
 * The new current point shall be (x3, y3).
 */
var c = /** @class */ (function (_super) {
    __extends(c, _super);
    function c(x1, y1, x2, y2, x3, y3) {
        var _this = _super.call(this) || this;
        _this.toString = function () {
            return _this.x1 + " " + _this.y1 + " " + _this.x2 + " " + _this.y2 + " " + _this.x3 + " " + _this.y3 + " c\n";
        };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validateArr([x1, y1, x2, y2, x3, y3], isNumber, 'c operator args "x1 y1 x2 y2 x3 y3" must all be numbers.');
        _this.x1 = x1;
        _this.y1 = y1;
        _this.x2 = x2;
        _this.y2 = y2;
        _this.x3 = x3;
        _this.y3 = y3;
        return _this;
    }
    c.of = function (x1, y1, x2, y2, x3, y3) { return new c(x1, y1, x2, y2, x3, y3); };
    return c;
}(PDFOperator));
export default c;
