var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-classes-per-file class-name */
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer } from '../../../../utils';
import { isNumber, validate } from '../../../../utils/validate';
/**
 * (lowercase L) Append a straight line segment from the current point to the
 *   point (x, y).
 * The new current point shall be (x, y).
 */
var l = /** @class */ (function (_super) {
    __extends(l, _super);
    function l(x, y) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.x + " " + _this.y + " l\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(x, isNumber, 'l operator arg "x" must be a number.');
        validate(y, isNumber, 'l operator arg "y" must be a number.');
        _this.x = x;
        _this.y = y;
        return _this;
    }
    l.of = function (x, y) { return new l(x, y); };
    return l;
}(PDFOperator));
export default l;
