import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Begin a new subpath by moving the current point to coordinates (x, y),
 *  omitting any connecting line segment.
 * If the previous path construction operator in the current path was also m,
 *  the new m overrides it; no vestige of the previous m operation remains in
 *  the path.
 */
declare class m extends PDFOperator {
    static of: (x: number, y: number) => m;
    x: number;
    y: number;
    constructor(x: number, y: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
export default m;
