var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-classes-per-file class-name */
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer } from '../../../../utils';
import { isNumber, validate } from '../../../../utils/validate';
/**
 * Begin a new subpath by moving the current point to coordinates (x, y),
 *  omitting any connecting line segment.
 * If the previous path construction operator in the current path was also m,
 *  the new m overrides it; no vestige of the previous m operation remains in
 *  the path.
 */
var m = /** @class */ (function (_super) {
    __extends(m, _super);
    function m(x, y) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.x + " " + _this.y + " m\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(x, isNumber, 'm operator arg "x" must be a number.');
        validate(y, isNumber, 'm operator arg "y" must be a number.');
        _this.x = x;
        _this.y = y;
        return _this;
    }
    m.of = function (x, y) { return new m(x, y); };
    return m;
}(PDFOperator));
export default m;
