import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Append a cubic Bézier curve to the current path.
 * The curve shall extend from the current point to the point (x3, y3), using
 *  the current point and (x2, y2) as the Bézier control points.
 * The new current point shall be (x3, y3).
 */
declare class v extends PDFOperator {
    static of: (x2: number, y2: number, x3: number, y3: number) => v;
    x2: number;
    y2: number;
    x3: number;
    y3: number;
    constructor(x2: number, y2: number, x3: number, y3: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
export default v;
