var __assign = (this && this.__assign) || Object.assign || function(t) {
    for (var s, i = 1, n = arguments.length; i < n; i++) {
        s = arguments[i];
        for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
            t[p] = s[p];
    }
    return t;
};
import W from './graphics/clipping-path/W';
import { CS, cs } from './graphics/color/CSOps';
import { G, g } from './graphics/color/GOps';
import { K, k } from './graphics/color/KOps';
import { RG, rg } from './graphics/color/RGOps';
import { SCN, scn } from './graphics/color/SCNOps';
import { SC, sc } from './graphics/color/SCOps';
import cm from './graphics/graphics-state/cm';
import d from './graphics/graphics-state/d';
import gs from './graphics/graphics-state/gs';
import i from './graphics/graphics-state/i';
import { J, j } from './graphics/graphics-state/JOps';
import M from './graphics/graphics-state/M';
import QOps from './graphics/graphics-state/QOps';
import ri from './graphics/graphics-state/ri';
import w from './graphics/graphics-state/w';
import c from './graphics/path-construction/c';
import h from './graphics/path-construction/h';
import l from './graphics/path-construction/l';
import m from './graphics/path-construction/m';
import re from './graphics/path-construction/re';
import v from './graphics/path-construction/v';
import y from './graphics/path-construction/y';
import * as pathPaintingOps from '../pdf-operators/graphics/path-painting';
import TAsterisk from './text/text-positioning/T-asterisk';
import { TD, Td } from './text/text-positioning/TDOps';
import Tm from './text/text-positioning/Tm';
import { DoubleQuote, SingleQuote } from './text/text-showing/QuoteOps';
import { TJ, Tj } from './text/text-showing/TJOps';
import Tc from './text/text-state/Tc';
import Tf from './text/text-state/Tf';
import TL from './text/text-state/TL';
import Tr from './text/text-state/Tr';
import Ts from './text/text-state/Ts';
import Tw from './text/text-state/Tw';
import Tz from './text/text-state/Tz';
import Do from './Do';
/*
 * These operator categories are defined in the
 * "Table 51 – Operator Categories" table in the PDF specification document
 */
export var generalGraphicsStateOperators = [w, J, j, M, d, ri, i, gs];
export var colorOperators = [CS, cs, SC, SCN, sc, scn, G, g, RG, rg, K, k];
export var textStateOperators = [Tc, Tw, Tz, TL, Tf, Tr, Ts];
export var textShowingOperators = [Tj, TJ, SingleQuote, DoubleQuote];
export var textPositioningOperators = [Td, TD, Tm, TAsterisk];
// TODO: These are valid in TextObjects, but they aren't implemented in
//       pdf-lib yet.
// export const markedContentOperators =
//   [MP, DP, BMC, BDC, EMC]
var PDFOperators = __assign({ W: W,
    CS: CS,
    cs: cs,
    SC: SC,
    sc: sc,
    SCN: SCN,
    scn: scn,
    G: G,
    g: g,
    RG: RG,
    rg: rg,
    K: K,
    k: k }, QOps, { cm: cm,
    w: w,
    M: M,
    d: d,
    ri: ri,
    i: i,
    gs: gs,
    J: J,
    j: j,
    c: c,
    h: h,
    l: l,
    m: m,
    re: re,
    v: v,
    y: y }, pathPaintingOps, { T: { asterisk: TAsterisk }, TD: TD,
    Td: Td,
    Tm: Tm, quote: { single: SingleQuote, double: DoubleQuote }, TJ: TJ,
    Tj: Tj,
    Tc: Tc,
    Tf: Tf,
    TL: TL,
    Tr: Tr,
    Ts: Ts,
    Tw: Tw,
    Tz: Tz,
    Do: Do });
export default PDFOperators;
