import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Move to the start of the next line, offset from the start of the current line by
 * (tx, ty). tx and ty shall denote numbers expressed in unscaled text space units.
 * More precisely, this operator shall perform these assignments:
 *              |1   0   0|
 * T_m = T_lm = |0   1   0| × T_lm
 *              |t_x t_y 1|
 */
export declare class Td extends PDFOperator {
    static of: (tx: number, ty: number) => Td;
    tx: number;
    ty: number;
    constructor(tx: number, ty: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
/**
 * Move to the start of the next line, offset from the start of the current line by
 * (tx, ty). As a side effect, this operator shall set the leading parameter in the
 * text state. This operator shall have the same effect as this code:
 * −ty TL
 * tx ty Td
 */
export declare class TD extends PDFOperator {
    static of: (tx: number, ty: number) => TD;
    tx: number;
    ty: number;
    constructor(tx: number, ty: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
