var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-classes-per-file class-name */
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer } from '../../../../utils';
import { isNumber, validate } from '../../../../utils/validate';
/**
 * Move to the start of the next line, offset from the start of the current line by
 * (tx, ty). tx and ty shall denote numbers expressed in unscaled text space units.
 * More precisely, this operator shall perform these assignments:
 *              |1   0   0|
 * T_m = T_lm = |0   1   0| × T_lm
 *              |t_x t_y 1|
 */
var Td = /** @class */ (function (_super) {
    __extends(Td, _super);
    function Td(tx, ty) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.tx + " " + _this.ty + " Td\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(tx, isNumber, 'Td operator arg "tx" must be a number.');
        validate(ty, isNumber, 'Td operator arg "ty" must be a number.');
        _this.tx = tx;
        _this.ty = ty;
        return _this;
    }
    Td.of = function (tx, ty) { return new Td(tx, ty); };
    return Td;
}(PDFOperator));
export { Td };
/**
 * Move to the start of the next line, offset from the start of the current line by
 * (tx, ty). As a side effect, this operator shall set the leading parameter in the
 * text state. This operator shall have the same effect as this code:
 * −ty TL
 * tx ty Td
 */
var TD = /** @class */ (function (_super) {
    __extends(TD, _super);
    function TD(tx, ty) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.tx + " " + _this.ty + " TD\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(tx, isNumber, 'TD operator arg "tx" must be a number.');
        validate(ty, isNumber, 'TD operator arg "ty" must be a number.');
        _this.tx = tx;
        _this.ty = ty;
        return _this;
    }
    TD.of = function (tx, ty) { return new TD(tx, ty); };
    return TD;
}(PDFOperator));
export { TD };
