var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-classes-per-file class-name */
import isString from 'lodash/isString';
import { PDFHexString, PDFString } from '../../../pdf-objects/index';
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer, or } from '../../../../utils';
import { isInstance, isNumber, validate } from '../../../../utils/validate';
/**
 * Move to the next line and show a text string.
 * This operator shall have the same effect as the code:
 * T*
 * string Tj
 */
var SingleQuote = /** @class */ (function (_super) {
    __extends(SingleQuote, _super);
    function SingleQuote(str) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.string.toString() + " '\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(str, or(isInstance(PDFString), isInstance(PDFHexString), isString), '\' operator arg "string" must be one of: PDFString, PDFHexString, String');
        _this.string = isString(str) ? PDFString.fromString(str) : str;
        return _this;
    }
    SingleQuote.of = function (str) { return new SingleQuote(str); };
    return SingleQuote;
}(PDFOperator));
export { SingleQuote };
/**
 * Move to the next line and show a text string, using aw as the word spacing
 * and ac as the character spacing (setting the corresponding parameters in the
 * text state). aw and ac shall be numbers expressed in unscaled text space units.
 * This operator shall have the same effect as this code:
 * aw Tw
 * ac Tc
 * string '
 */
var DoubleQuote = /** @class */ (function (_super) {
    __extends(DoubleQuote, _super);
    function DoubleQuote(aw, ac, str) {
        var _this = _super.call(this) || this;
        _this.toString = function () {
            return _this.aw + " " + _this.ac + " " + _this.string.toString() + " \"\n";
        };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(aw, isNumber, '" operator arg "aw" must be a Number');
        validate(ac, isNumber, '" operator arg "ac" must be a Number');
        validate(str, or(isInstance(PDFString), isInstance(PDFHexString), isString), '" operator arg "string" must be one of: PDFString, PDFHexString, String');
        _this.aw = aw;
        _this.ac = ac;
        _this.string = isString(str) ? PDFString.fromString(str) : str;
        return _this;
    }
    DoubleQuote.of = function (aw, ac, str) { return new DoubleQuote(aw, ac, str); };
    return DoubleQuote;
}(PDFOperator));
export { DoubleQuote };
