import { PDFHexString, PDFNumber, PDFString } from '../../../pdf-objects/index';
import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Show a text string.
 */
export declare class Tj extends PDFOperator {
    static of: (str: string | PDFHexString | PDFString) => Tj;
    string: PDFString | PDFHexString;
    constructor(str: PDFString | PDFHexString | string);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
/**
 * Show one or more text strings, allowing individual glyph positioning.
 * Each element of array shall be either a string or a number.
 * If the element is a string, this operator shall show the string.
 * If it is a number, the operator shall adjust the text position by that
 *  amount; that is, it shall translate the text matrix, Tm.
 * The number shall be expressed in thousandths of a unit of text space.
 * This amount shall be subtracted from the current horizontal or vertical
 *   coordinate, depending on the writing mode.
 * In the default coordinate system, a positive adjustment has the effect of
 * moving the next glyph painted either to the left or down by the given amount.
 */
export declare class TJ extends PDFOperator {
    static of: (...array: (string | number | PDFHexString | PDFString)[]) => TJ;
    array: Array<PDFString | PDFHexString | PDFNumber>;
    constructor(...array: Array<PDFString | PDFHexString | PDFNumber | string | number>);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
