var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* tslint:disable:max-classes-per-file class-name */
import add from 'lodash/add';
import isNumber from 'lodash/isNumber';
import isString from 'lodash/isString';
import { PDFHexString, PDFNumber, PDFString } from '../../../pdf-objects/index';
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer, arrayToString, error, or } from '../../../../utils';
import { isInstance, validate, validateArr } from '../../../../utils/validate';
/**
 * Show a text string.
 */
var Tj = /** @class */ (function (_super) {
    __extends(Tj, _super);
    function Tj(str) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.string + " Tj\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(str, or(isInstance(PDFString), isInstance(PDFHexString), isString), 'Tj operator arg "str" must be one of: PDFString, PDFHexString, String');
        _this.string = isString(str) ? PDFString.fromString(str) : str;
        return _this;
    }
    Tj.of = function (str) { return new Tj(str); };
    return Tj;
}(PDFOperator));
export { Tj };
/**
 * Show one or more text strings, allowing individual glyph positioning.
 * Each element of array shall be either a string or a number.
 * If the element is a string, this operator shall show the string.
 * If it is a number, the operator shall adjust the text position by that
 *  amount; that is, it shall translate the text matrix, Tm.
 * The number shall be expressed in thousandths of a unit of text space.
 * This amount shall be subtracted from the current horizontal or vertical
 *   coordinate, depending on the writing mode.
 * In the default coordinate system, a positive adjustment has the effect of
 * moving the next glyph painted either to the left or down by the given amount.
 */
var TJ = /** @class */ (function (_super) {
    __extends(TJ, _super);
    function TJ() {
        var array = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            array[_i] = arguments[_i];
        }
        var _this = _super.call(this) || this;
        _this.toString = function () {
            var buffer = new Uint8Array(_this.bytesSize());
            _this.copyBytesInto(buffer);
            return arrayToString(buffer);
        };
        _this.bytesSize = function () {
            return _this.array.map(function (elem) { return elem.bytesSize(); }).reduce(add, 0) +
                _this.array.length + // Spaces between elements
                4 + // "[ " and "]"
                3;
        }; // The "TJ" characters and trailing newline
        _this.copyBytesInto = function (buffer) {
            var remaining = addStringToBuffer('[ ', buffer);
            _this.array.forEach(function (elem) {
                remaining = elem.copyBytesInto(remaining);
                remaining = addStringToBuffer(' ', remaining);
            });
            remaining = addStringToBuffer('] TJ\n', remaining);
            return remaining;
        };
        if (array.length === 0) {
            error('TJ operator requires  PDFStrings, PDFHexStrings, PDFNumbers, Strings, or Numbers to be constructed');
        }
        validateArr(array, or(isInstance(PDFString), isInstance(PDFHexString), isInstance(PDFNumber), isString, isNumber), 'TJ operator arg elements must be one of: PDFString, PDFHexString, PDFNumber, String, Number');
        // prettier-ignore
        _this.array = array.map(function (elem) {
            return isString(elem) ? PDFString.fromString(elem)
                : isNumber(elem) ? PDFNumber.fromNumber(elem)
                    : elem;
        });
        return _this;
    }
    TJ.of = function () {
        var array = [];
        for (var _i = 0; _i < arguments.length; _i++) {
            array[_i] = arguments[_i];
        }
        return new (TJ.bind.apply(TJ, [void 0].concat(array)))();
    };
    return TJ;
}(PDFOperator));
export { TJ };
