var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* eslint-disable new-cap */
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer } from '../../../../utils';
import { isNumber, validate } from '../../../../utils/validate';
/**
 * Set the text leading, Tl, to leading, which shall be a number expressed in
 * unleading text space units. Text leading shall be used only by the T*, ', and "
 * operators. Initial value: 0.
 */
var TL = /** @class */ (function (_super) {
    __extends(TL, _super);
    function TL(leading) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.leading + " TL\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(leading, isNumber, 'TL operator arg "leading" must be a number.');
        _this.leading = leading;
        return _this;
    }
    TL.of = function (leading) { return new TL(leading); };
    return TL;
}(PDFOperator));
export default TL;
