var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* eslint-disable new-cap */
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer } from '../../../../utils';
import { isNumber, validate } from '../../../../utils/validate';
/**
 * Set the text rise, Tsise, to rise, which shall be a number expressed in unscaled
 * text space units. Initial value: 0.
 */
var Ts = /** @class */ (function (_super) {
    __extends(Ts, _super);
    function Ts(rise) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.rise + " Ts\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(rise, isNumber, 'Ts operator arg "rise" must be a number.');
        _this.rise = rise;
        return _this;
    }
    Ts.of = function (rise) { return new Ts(rise); };
    return Ts;
}(PDFOperator));
export default Ts;
