import PDFOperator from '../../../pdf-operators/PDFOperator';
/**
 * Set the word spacing, Tw, to wordSpace, which shall be a number expressed in
 * unscaled text space units. Word spacing shall be used by the Tj, TJ, and '
 * operators. Initial value: 0.
 */
declare class Tw extends PDFOperator {
    static of: (wordSpace: number) => Tw;
    wordSpace: number;
    constructor(wordSpace: number);
    toString: () => string;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
}
export default Tw;
