var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
/* eslint-disable new-cap */
import PDFOperator from '../../../pdf-operators/PDFOperator';
import { addStringToBuffer } from '../../../../utils';
import { isNumber, validate } from '../../../../utils/validate';
/**
 * Set the word spacing, Tw, to wordSpace, which shall be a number expressed in
 * unscaled text space units. Word spacing shall be used by the Tj, TJ, and '
 * operators. Initial value: 0.
 */
var Tw = /** @class */ (function (_super) {
    __extends(Tw, _super);
    function Tw(wordSpace) {
        var _this = _super.call(this) || this;
        _this.toString = function () { return _this.wordSpace + " Tw\n"; };
        _this.bytesSize = function () { return _this.toString().length; };
        _this.copyBytesInto = function (buffer) {
            return addStringToBuffer(_this.toString(), buffer);
        };
        validate(wordSpace, isNumber, 'Tw operator arg "wordSpace" must be a number.');
        _this.wordSpace = wordSpace;
        return _this;
    }
    Tw.of = function (wordSpace) { return new Tw(wordSpace); };
    return Tw;
}(PDFOperator));
export default Tw;
