import { PDFArray, PDFBoolean, PDFDictionary, PDFHexString, PDFIndirectObject, PDFIndirectReference, PDFName, PDFNull, PDFNumber, PDFStream, PDFString } from '../pdf-objects';
import { PDFCatalog, PDFHeader, PDFObjectStream, PDFTrailer, PDFXRef } from '../pdf-structures';
import PDFObjectIndex from '../pdf-document/PDFObjectIndex';
import { IPDFLinearization } from './parseLinearization';
export interface IParseHandlers {
    onParseBool?: (p: PDFBoolean) => any;
    onParseArray?: (p: PDFArray) => any;
    onParseDict?: (p: PDFDictionary) => any;
    onParseHexString?: (p: PDFHexString) => any;
    onParseName?: (p: PDFName) => any;
    onParseNull?: (p: PDFNull) => any;
    onParseNumber?: (p: PDFNumber) => any;
    onParseString?: (p: PDFString) => any;
    onParseStream?: (p: PDFStream) => any;
    onParseObjectStream?: (p: PDFObjectStream) => any;
    onParseIndirectRef?: (p: PDFIndirectReference) => any;
    onParseIndirectObj?: (p: PDFIndirectObject) => any;
    onParseHeader?: (p: PDFHeader) => any;
    onParseXRefTable?: (p: PDFXRef.Table) => any;
    onParseTrailer?: (p: PDFTrailer) => any;
    onParseLinearization?: (p: IPDFLinearization) => any;
}
export interface IParsedPDF {
    maxObjectNumber: number;
    catalog: PDFCatalog;
    arrays: PDFArray[];
    dictionaries: PDFDictionary[];
    original: {
        header: PDFHeader;
        linearization: IPDFLinearization;
        body: Map<PDFIndirectReference, PDFIndirectObject>;
        xRefTable: PDFXRef.Table;
        trailer: PDFTrailer;
    };
    updates: Array<{
        body: Map<PDFIndirectReference, PDFIndirectObject>;
        xRefTable?: PDFXRef.Table;
        trailer?: PDFTrailer;
    }>;
}
declare class PDFParser {
    private activelyParsing;
    private maxObjectNumber;
    private arrays;
    private dictionaries;
    private catalog?;
    private header?;
    private body;
    private xRefTable?;
    private trailer?;
    private linearization?;
    private updates;
    private parseHandlers;
    constructor();
    parse: (bytes: Uint8Array, index: PDFObjectIndex) => IParsedPDF;
    private updateMaxObjectNumber;
    private handleArray;
    private handleDict;
    private handleObjectStream;
    private handleIndirectObj;
    private handleHeader;
    private handleXRefTable;
    private handleTrailer;
    private handleLinearization;
}
export default PDFParser;
