import { PDFArray } from '../../pdf-objects';
import pako from 'pako';
var decodeStream = function (data, _a) {
    var filter = _a.key;
    if (filter === 'FlateDecode')
        return pako.inflate(data);
    // TODO: Implement support for all other filter types
    if (filter === 'DCTDecode')
        return data;
    throw new Error("Unknown stream filter type: " + filter);
};
export default (function (dict, contents) {
    var filters = dict.get('Filter');
    if (filters) {
        var filtersArr = filters instanceof PDFArray ? filters.array : [filters];
        return filtersArr.reduce(decodeStream, contents);
    }
    return contents;
});
