import { PDFArray, PDFObject } from '../pdf-objects';
import PDFObjectIndex from '../pdf-document/PDFObjectIndex';
import { IParseHandlers } from './PDFParser';
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in the
 * trimmed input make up a PDF Array.
 *
 * If so, returns a tuple containing (1) an object representing the parsed PDFArray
 * and (2) a subarray of the input with the characters making up the parsed array
 * removed. The "onParseArray" parse handler will also be called with the PDFArray
 * object.
 *
 * If not, null is returned.
 *
 * Note that the elements of the PDF Array are recursively parsed, so the
 * appropriate parse handlers will be called when each element of the array is
 * parsed. The returned PDFArray's elements will be composed of PDFObjects.
 */
declare const parseArray: (input: Uint8Array, index: PDFObjectIndex, parseHandlers?: IParseHandlers) => void | [PDFArray<PDFObject>, Uint8Array];
export default parseArray;
