import { PDFBoolean } from '../pdf-objects';
import { IParseHandlers } from './PDFParser';
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in
 * the trimmed input make up a PDF Boolean.
 *
 * If so, returns a tuple containing (1) an object representing the parsed
 * PDF Boolean and (2) a subarray of the input with the characters making up the
 * parsed header removed. The "onParseBool" parse handler will also be called
 * with the PDFBoolean object.
 *
 * If not, null is returned.
 */
declare const parseBool: (input: Uint8Array, { onParseBool }?: IParseHandlers) => void | [PDFBoolean, Uint8Array];
export default parseBool;
