import { PDFHeader } from '../pdf-structures';
import { IParseHandlers } from './PDFParser';
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in the
 * trimmed input make up a PDF Header.
 *
 * If so, returns a tuple containing (1) an object representing the parsed PDF
 * Header and (2) a subarray of the input with the characters making up the parsed
 * header removed. The "onParseHeader" parse handler will also be called with the
 * PDFHeader obect.
 *
 * If not, null is returned.
 */
declare const parseHeader: (input: Uint8Array, { onParseHeader }?: IParseHandlers) => void | [PDFHeader, Uint8Array];
export default parseHeader;
