import { PDFHexString } from '../pdf-objects';
import { IParseHandlers } from './PDFParser';
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in the
 * trimmed input make up a PDF Hex String.
 *
 * If so, returns a tuple containing (1) an object representing the parsed PDF Hex
 * String and (2) a subarray of the input with the characters making up the parsed
 * hex string removed. The "onParseHexString" parse handle will also be called with
 * the PDFHexString object.
 *
 * If not, null is returned.
 */
declare const parseHexString: (input: Uint8Array, { onParseHexString }?: IParseHandlers) => void | [PDFHexString, Uint8Array];
export default parseHexString;
