// tslint:disable-next-line:no-unused-variable
import { PDFIndirectReference } from '../pdf-objects';
import { arrayIndexOf, arrayToString, trimArrayAndRemoveComments } from '../../utils';
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in the
 * trimmed input make up a PDF Indirect Reference.
 *
 * If so, returns a tuple containing (1) an object representing the parsed PDF
 * Indirect Reference and (2) a subarray of the input with the characters making up
 * the parsed indirect reference removed. The "onParseIndirectRef" parse handler
 * will also be called with the PDFIndirectReference.
 *
 * If not, null is returned.
 */
var parseIndirectRef = function (input, _a) {
    var onParseIndirectRef = (_a === void 0 ? {} : _a).onParseIndirectRef;
    var trimmed = trimArrayAndRemoveComments(input);
    var indirectRefRegex = /^(\d+)[\0\t\n\f\r ]*(\d+)[\0\t\n\f\r ]*R/;
    // Check that initial characters make up an indirect reference
    var rIdx = arrayIndexOf(trimmed, 'R');
    var result = arrayToString(trimmed, 0, rIdx + 1).match(indirectRefRegex);
    if (!result)
        return undefined;
    var fullMatch = result[0], objNum = result[1], genNum = result[2];
    var ref = PDFIndirectReference.forNumbers(Number(objNum), Number(genNum));
    if (onParseIndirectRef)
        onParseIndirectRef(ref);
    return [ref, trimmed.subarray(fullMatch.length)];
};
export default parseIndirectRef;
