import { PDFIndirectObject, PDFStream } from '../pdf-objects';
import { PDFLinearizationParams, PDFTrailer, PDFXRef } from '../pdf-structures';
import PDFObjectIndex from '../pdf-document/PDFObjectIndex';
import { IParseHandlers } from './PDFParser';
export interface IPDFLinearization {
    paramDict: PDFIndirectObject<PDFLinearizationParams>;
    xref: typeof PDFXRef.Table | PDFIndirectObject<PDFStream>;
    trailer?: PDFTrailer;
}
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in the
 * trimmed input make up a PDF Linearization Param Dict, followed by an xref table
 * or stream, and finally a trailer.
 *
 * If so, returns a tuple containing (1) an object representing those three objects
 * and (2) a subarray of the input with the characters making up the parsed objects
 * removed. The "onParseDict" parse handler will be called with the linearization
 * param dict. The "onParseLinearization" parse handler will also be called with
 * objects representing the three parsed linearization objects.
 *
 * If not, null is returned.
 */
declare const parseLinearization: (input: Uint8Array, index: PDFObjectIndex, parseHandlers?: IParseHandlers) => void | [IPDFLinearization, Uint8Array];
export default parseLinearization;
