import { PDFName } from '../pdf-objects';
import { IParseHandlers } from './PDFParser';
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in the
 * trimmed input make up a PDF Name.
 *
 * If so, returns a tuple containing (1) an object representing the parsed PDF Name
 * and (2) a subarray of the input with the characters making up the parsed name
 * removed. The "onParseName" parse handler will also be called with the PDFName
 * object.
 *
 * If not, null is returned.
 */
declare const parseName: (input: Uint8Array, { onParseName }?: IParseHandlers) => void | [PDFName, Uint8Array];
export default parseName;
