import { PDFNull } from '../pdf-objects';
import { IParseHandlers } from './PDFParser';
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in the
 * trimmed input make up a PDF Null value.
 *
 * If so, returns a tuple containing (1) an object representing the parsed PDF Null
 * value and (2) a subarray of the input with the characters making up the parsed
 * null value removed. The "onParseNull" parse handler will also be called with the
 * PDFNull object.
 *
 * If not, null is returned.
 */
declare const parseNull: (input: Uint8Array, { onParseNull }?: IParseHandlers) => void | [PDFNull, Uint8Array];
export default parseNull;
