import { PDFString } from '../pdf-objects';
import { IParseHandlers } from './PDFParser';
/**
 * Accepts an array of bytes as input. Checks to see if the first characters in the
 * trimmed input make up a PDF String.
 *
 * If so, returns a tuple containing (1) an object representing the parsed PDF
 * String and (2) a subarray of the input with the characters making up the parsed
 * string removed. The "onParseString" parse handler will also be called with the
 * PDFString object.
 *
 * If not, returns null.
 */
declare const parseString: (input: Uint8Array, { onParseString }?: IParseHandlers) => void | [PDFString, Uint8Array];
export default parseString;
