var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import { PDFIndirectReference, PDFName } from '../pdf-objects';
import PDFDictionary from '../pdf-objects/PDFDictionary';
import { isInstance, validate } from '../../utils/validate';
var VALID_KEYS = Object.freeze([
    'Type',
    'Version',
    'Extensions',
    'Pages',
    'PageLabels',
    'Names',
    'Dests',
    'ViewerPreferences',
    'PageLayout',
    'PageMode',
    'Outlines',
    'Threads',
    'OpenAction',
    'AA',
    'URI',
    'AcroForm',
    'Metadata',
    'StructTreeRoot',
    'MarkInfo',
    'Lang',
    'SpiderInfo',
    'OutputIntents',
    'PieceInfo',
    'OCProperties',
    'Perms',
    'Legal',
    'Requirements',
    'Collection',
    'NeedsRendering',
]);
var PDFCatalog = /** @class */ (function (_super) {
    __extends(PDFCatalog, _super);
    function PDFCatalog() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(PDFCatalog.prototype, "Pages", {
        get: function () {
            var Pages = this.get('Pages');
            return this.index.lookup(Pages);
        },
        enumerable: true,
        configurable: true
    });
    PDFCatalog.create = function (pageTree, index) {
        validate(pageTree, isInstance(PDFIndirectReference), '"pageTree" must be an indirect reference');
        return new PDFCatalog({
            Type: PDFName.from('Catalog'),
            Pages: pageTree,
        }, index);
    };
    PDFCatalog.fromObject = function (object, index) { return new PDFCatalog(object, index, VALID_KEYS); };
    PDFCatalog.fromDict = function (dict) {
        validate(dict, isInstance(PDFDictionary), '"dict" must be a PDFDictionary');
        return new PDFCatalog(dict.map, dict.index, VALID_KEYS);
    };
    return PDFCatalog;
}(PDFDictionary));
export default PDFCatalog;
