var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import add from 'lodash/add';
import flatten from 'lodash/flatten';
import isNumber from 'lodash/isNumber';
import pako from 'pako';
import '../pdf-objects';
import { PDFName, PDFNumber, PDFStream } from '../pdf-objects';
import PDFOperator from '../pdf-operators/PDFOperator';
import { addStringToBuffer, or } from '../../utils';
import { typedArrayProxy } from '../../utils/proxies';
import { isArrayOf, isInstance, validateArr } from '../../utils/validate';
var PDFContentStream = /** @class */ (function (_super) {
    __extends(PDFContentStream, _super);
    function PDFContentStream(dictionary) {
        var operators = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            operators[_i - 1] = arguments[_i];
        }
        var _this = _super.call(this, dictionary) || this;
        // Note: If this PDFContentStream is encoded when it is cloned, the
        //       clone will *not* be encoded.
        _this.clone = function () {
            var clonedDict = _this.dictionary.clone();
            clonedDict.delete('Filter');
            var cloned = PDFContentStream.of.apply(PDFContentStream, [clonedDict].concat(_this.operators));
            return cloned;
        };
        _this.encode = function () {
            _this.dictionary.set(PDFName.from('Filter'), PDFName.from('FlateDecode'));
            var buffer = new Uint8Array(_this.operatorsBytesSize());
            _this.copyOperatorBytesInto(buffer);
            _this.encodedOperators = pako.deflate(buffer);
            _this.dictionary.set('Length', PDFNumber.fromNumber(_this.encodedOperators.length));
            return _this;
        };
        _this.operatorsBytesSize = function () {
            return _this.encodedOperators
                ? _this.encodedOperators.length
                : _this.operators
                    .filter(Boolean)
                    .map(function (op) { return op.bytesSize(); })
                    .reduce(add, 0);
        };
        _this.bytesSize = function () {
            return _this.dictionary.bytesSize() +
                1 + // "\n"
                7 + // "stream\n"
                _this.operatorsBytesSize() +
                10;
        }; // \nendstream
        _this.copyBytesInto = function (buffer) {
            _this.validateDictionary();
            var remaining = _this.dictionary.copyBytesInto(buffer);
            remaining = addStringToBuffer('\nstream\n', remaining);
            if (_this.encodedOperators) {
                for (var i = 0; i < _this.encodedOperators.length; i++) {
                    remaining[i] = _this.encodedOperators[i];
                }
                remaining = remaining.subarray(_this.encodedOperators.length);
            }
            else {
                remaining = _this.copyOperatorBytesInto(remaining);
            }
            remaining = addStringToBuffer('\nendstream', remaining);
            return remaining;
        };
        _this.copyOperatorBytesInto = function (buffer) {
            return _this.operators
                .filter(Boolean)
                .reduce(function (remBytes, op) { return op.copyBytesInto(remBytes); }, buffer);
        };
        validateArr(operators, or(isInstance(PDFOperator), isArrayOf(PDFOperator)), 'PDFContentStream requires PDFOperators or PDFOperator[]s to be constructed.');
        _this.operators = typedArrayProxy(flatten(operators), PDFOperator, {
            set: function (property) {
                if (isNumber(Number(property))) {
                    _this.Length.number = _this.operatorsBytesSize();
                }
            },
        });
        _this.dictionary.set('Length', PDFNumber.fromNumber(_this.operatorsBytesSize()));
        return _this;
    }
    Object.defineProperty(PDFContentStream.prototype, "Length", {
        get: function () {
            var Length = this.dictionary.get('Length');
            return this.dictionary.index.lookup(Length);
        },
        enumerable: true,
        configurable: true
    });
    PDFContentStream.of = function (dict) {
        var operators = [];
        for (var _i = 1; _i < arguments.length; _i++) {
            operators[_i - 1] = arguments[_i];
        }
        return new (PDFContentStream.bind.apply(PDFContentStream, [void 0, dict].concat(operators)))();
    };
    PDFContentStream.validateOperators = function (elements) {
        return validateArr(elements, isInstance(PDFOperator), 'Only PDFOperators can be pushed to a PDFContentStream.');
    };
    return PDFContentStream;
}(PDFStream));
export default PDFContentStream;
