import isNumber from 'lodash/isNumber';
import { addStringToBuffer, toCharCode } from '../../utils';
import { validate } from '../../utils/validate';
var PDFHeader = /** @class */ (function () {
    function PDFHeader(major, minor) {
        var _this = this;
        this.toString = function () { return "%PDF-" + _this.major + "." + _this.minor + "\n"; };
        this.bytesSize = function () { return ("%PDF-" + _this.major + "." + _this.minor + "\n").length + 6; };
        this.copyBytesInto = function (buffer) {
            var remaining = addStringToBuffer("%PDF-" + _this.major + "." + _this.minor + "\n", buffer);
            remaining.set([toCharCode('%'), 130, 130, 130, 130, toCharCode('\n')], 0);
            return remaining.subarray(6);
        };
        validate(major, isNumber, 'PDFHeader.major must be a Number');
        validate(minor, isNumber, 'PDFHeader.minor must be a Number');
        this.major = major;
        this.minor = minor;
    }
    PDFHeader.forVersion = function (major, minor) {
        return new PDFHeader(major, minor);
    };
    return PDFHeader;
}());
export default PDFHeader;
