var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import add from 'lodash/add';
import dropRight from 'lodash/dropRight';
import flatten from 'lodash/flatten';
import last from 'lodash/last';
import pako from 'pako';
import { PDFDictionary, PDFIndirectObject, PDFName, PDFNumber, PDFStream, } from '../pdf-objects';
import { addStringToBuffer } from '../../utils';
import { isInstance, validateArr } from '../../utils/validate';
var PDFObjectStream = /** @class */ (function (_super) {
    __extends(PDFObjectStream, _super);
    function PDFObjectStream(dictionary, objects) {
        var _this = _super.call(this, dictionary) || this;
        _this.objectByteSizes = [];
        _this.encode = function () {
            _this.updateObjectByteSizes();
            _this.dictionary.set(PDFName.from('Filter'), PDFName.from('FlateDecode'));
            var buffer = new Uint8Array(_this.contentBytesSize());
            _this.copyContentBytesInto(buffer);
            _this.encodedContents = pako.deflate(buffer);
            return _this;
        };
        _this.bytesSize = function () {
            if (_this.objectByteSizes.length === 0)
                _this.updateObjectByteSizes();
            _this.updateDictionary();
            return (_this.dictionary.bytesSize() +
                1 + // "\n"
                7 + // "stream\n"
                _this.contentBytesSize() +
                10 // \nendstream
            );
        };
        _this.copyBytesInto = function (buffer) {
            if (_this.objectByteSizes.length === 0)
                _this.updateObjectByteSizes();
            _this.updateDictionary();
            _this.validateDictionary();
            var remaining = _this.dictionary.copyBytesInto(buffer);
            remaining = addStringToBuffer('\nstream\n', remaining);
            if (_this.encodedContents) {
                for (var i = 0; i < _this.encodedContents.length; i++) {
                    remaining[i] = _this.encodedContents[i];
                }
                remaining = remaining.subarray(_this.encodedContents.length);
            }
            else {
                remaining = _this.copyContentBytesInto(remaining);
            }
            remaining = addStringToBuffer('\nendstream', remaining);
            return remaining;
        };
        _this.copyContentBytesInto = function (buffer) {
            var remaining = addStringToBuffer(_this.leadingIntegerPairsStr(), buffer);
            return _this.objects.reduce(function (remBytes, obj) {
                return addStringToBuffer('\n', obj.pdfObject.copyBytesInto(remBytes));
            }, remaining);
        };
        _this.updateObjectByteSizes = function () {
            // "+ 1" for the newline we add to separate the objects
            _this.objectByteSizes = _this.objects.map(function (obj) { return obj.pdfObject.bytesSize() + 1; });
        };
        _this.contentBytesSize = function () {
            return _this.encodedContents
                ? _this.encodedContents.length
                : _this.leadingIntegerPairsStr().length +
                    _this.objectByteSizes.reduce(add, 0);
        };
        _this.leadingIntegerPairsStr = function () {
            return flatten(_this.leadingIntegerPairs()).join(' ') + '\n';
        };
        _this.leadingIntegerPairs = function () {
            var byteOffsets = _this.objectByteOffsets();
            return _this.objects.map(function (obj, idx) {
                return [obj.reference.objectNumber, byteOffsets[idx]];
            });
        };
        _this.objectByteOffsets = function () {
            var offsets = [0];
            dropRight(_this.objectByteSizes).forEach(function (byteSize) {
                offsets.push(last(offsets) + byteSize);
            });
            return offsets;
        };
        _this.updateDictionary = function () {
            _this.dictionary.set(PDFName.from('Length'), PDFNumber.fromNumber(_this.contentBytesSize()));
            _this.dictionary.set(PDFName.from('N'), PDFNumber.fromNumber(_this.objects.length));
            _this.dictionary.set(PDFName.from('First'), PDFNumber.fromNumber(_this.leadingIntegerPairsStr().length));
        };
        validateArr(objects, isInstance(PDFIndirectObject), 'PDFObjectStream.objects must be an array of PDFIndirectObject');
        _this.objects = objects;
        return _this;
    }
    PDFObjectStream.create = function (index, objects) {
        return new PDFObjectStream(new PDFDictionary({ Type: PDFName.from('ObjStm') }, index), objects);
    };
    PDFObjectStream.from = function (dictionary, objects) {
        return new PDFObjectStream(dictionary, objects);
    };
    return PDFObjectStream;
}(PDFStream));
export default PDFObjectStream;
