import isNil from 'lodash/isNil';
import isNumber from 'lodash/isNumber';
import { addStringToBuffer, or } from '../../utils';
import { isInstance, validate } from '../../utils/validate';
import { PDFDictionary } from '../pdf-objects';
var PDFTrailer = /** @class */ (function () {
    function PDFTrailer(offset, dictionary) {
        var _this = this;
        this.toString = function () {
            return (_this.dictionary ? "trailer\n" + _this.dictionary.toString() + "\n" : '') +
                "startxref\n" +
                (_this.offset + "\n") +
                "%%EOF\n";
        };
        this.bytesSize = function () {
            return (_this.dictionary
                ? 8 /* "trailer\n" */ + _this.dictionary.bytesSize() + 1 /* "\n" */
                : 0) +
                10 + // "startxref\n"
                String(_this.offset).length +
                1 + // "\n"
                6;
        }; // "%%EOF\n"
        this.copyBytesInto = function (buffer) {
            var remaining = buffer;
            if (_this.dictionary) {
                remaining = addStringToBuffer('trailer\n', remaining);
                remaining = _this.dictionary.copyBytesInto(remaining);
                remaining = addStringToBuffer('\n', remaining);
            }
            remaining = addStringToBuffer("startxref\n" + _this.offset + "\n%%EOF\n", remaining);
            return remaining;
        };
        validate(offset, isNumber, 'PDFTrailer.offset must be a number');
        validate(dictionary, or(isNil, isInstance(PDFDictionary)), 'PDFTrailer.dictionary must be instance of PDFDictionary or undefined');
        this.offset = offset;
        this.dictionary = dictionary;
    }
    PDFTrailer.from = function (offset, dictionary) {
        return new PDFTrailer(offset, dictionary);
    };
    return PDFTrailer;
}());
export default PDFTrailer;
