/* tslint:disable:max-classes-per-file */
import add from 'lodash/add';
import isBoolean from 'lodash/isBoolean';
import isNumber from 'lodash/isNumber';
import padStart from 'lodash/padStart';
import { addStringToBuffer } from '../../utils';
import { isInstance, validate, validateArr } from '../../utils/validate';
var Entry = /** @class */ (function () {
    function Entry() {
        var _this = this;
        this.isInUse = false;
        this.setOffset = function (offset) {
            validate(offset, isNumber, 'offset must be a number');
            _this.offset = offset;
            return _this;
        };
        this.setGenerationNum = function (generationNum) {
            validate(generationNum, isNumber, 'generationNum must be a number');
            _this.generationNum = generationNum;
            return _this;
        };
        this.setIsInUse = function (isInUse) {
            validate(isInUse, isBoolean, 'isInUse must be a boolean');
            _this.isInUse = isInUse;
            return _this;
        };
        this.toString = function () {
            return padStart(String(_this.offset), 10, '0') + " " +
                (padStart(String(_this.generationNum), 5, '0') + " ") +
                ((_this.isInUse ? 'n' : 'f') + " \n");
        };
        this.bytesSize = function () { return _this.toString().length; };
    }
    Entry.create = function () { return new Entry(); };
    return Entry;
}());
export { Entry };
var Subsection = /** @class */ (function () {
    function Subsection(entries) {
        if (entries === void 0) { entries = []; }
        var _this = this;
        this.entries = [];
        this.addEntry = function (entry) {
            validate(entry, isInstance(Entry), '"entry" must be instance of PDFXRef.Entry');
            _this.entries.push(entry);
            return _this;
        };
        this.setFirstObjNum = function (firstObjNum) {
            validate(firstObjNum, isNumber, 'firstObjNum must be a number');
            _this.firstObjNum = firstObjNum;
            return _this;
        };
        this.toString = function () {
            return _this.firstObjNum + " " + _this.entries.length + "\n" +
                ("" + _this.entries.map(String).join(''));
        };
        this.bytesSize = function () {
            return (_this.firstObjNum + " " + _this.entries.length + "\n").length +
                _this.entries.map(function (e) { return e.bytesSize(); }).reduce(add, 0);
        };
        validateArr(entries, isInstance(Entry), 'PDFXRef.Subsection.entries must be an array of PDFXRef.Entry');
        this.entries = entries;
    }
    Subsection.from = function (entries) {
        if (entries === void 0) { entries = []; }
        return new Subsection(entries);
    };
    return Subsection;
}());
export { Subsection };
var Table = /** @class */ (function () {
    function Table(subsections) {
        if (subsections === void 0) { subsections = []; }
        var _this = this;
        this.subsections = [];
        this.addSubsection = function (subsection) {
            validate(subsection, isInstance(Subsection), '"subsection" must be instance of PDFXRef.Subsection');
            _this.subsections.push(subsection);
            return _this;
        };
        this.toString = function () { return "xref\n" + _this.subsections.map(String).join('\n') + "\n"; };
        this.bytesSize = function () {
            return 5 + _this.subsections.map(function (ss) { return ss.bytesSize() + 1; }).reduce(add, 0);
        }; // "xref\n"
        this.copyBytesInto = function (buffer) {
            var remaining = addStringToBuffer('xref\n', buffer);
            _this.subsections.map(String).forEach(function (subsectionStr) {
                remaining = addStringToBuffer(subsectionStr + "\n", remaining);
            });
            return remaining;
        };
        validateArr(subsections, isInstance(Subsection), 'subsections must be an array of PDFXRef.Subsection');
        this.subsections = subsections;
    }
    Table.from = function (subsections) {
        if (subsections === void 0) { subsections = []; }
        return new Table(subsections);
    };
    return Table;
}());
export { Table };
