import { PDFObjectIndex } from '../pdf-document';
import { PDFIndirectReference, PDFNumber, PDFStream } from '../pdf-objects';
import { PDFCatalog } from '../pdf-structures';
declare class PDFXRefStream extends PDFStream {
    static create: (config: {
        Size: PDFNumber;
        Root: PDFIndirectReference<PDFCatalog>;
    }, index: PDFObjectIndex) => PDFXRefStream;
    private entries;
    private encodedEntries;
    constructor({Size, Root}: {
        Size: PDFNumber;
        Root: PDFIndirectReference<PDFCatalog>;
    }, index: PDFObjectIndex);
    addFreeObjectEntry: (nextFreeObjectNum: number, generationNum: number) => void;
    addUncompressedObjectEntry: (byteOffset: number, generationNum: number) => void;
    addCompressedObjectEntry: (objectStreamNum: number, index: number) => void;
    encode: () => this;
    bytesSize: () => number;
    copyBytesInto: (buffer: Uint8Array) => Uint8Array;
    private contentBytesSize;
    private copyEntryBytesInto;
    private entriesBytesSize;
    private maxEntryByteWidths;
    private updateDictionary;
}
export default PDFXRefStream;
