var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
import flatten from 'lodash/flatten';
import max from 'lodash/max';
import sum from 'lodash/sum';
import pako from 'pako';
import { PDFArray, PDFDictionary, PDFName, PDFNumber, PDFStream, } from '../pdf-objects';
import { addStringToBuffer, bytesFor, reverseArray, sizeInBytes } from '../../utils';
var PDFXRefStream = /** @class */ (function (_super) {
    __extends(PDFXRefStream, _super);
    function PDFXRefStream(_a, index) {
        var Size = _a.Size, Root = _a.Root;
        var _this = _super.call(this, new PDFDictionary({ Type: PDFName.from('XRef'), Size: Size, Root: Root }, index)) || this;
        _this.entries = [];
        _this.addFreeObjectEntry = function (nextFreeObjectNum, generationNum) {
            _this.entries.push([0, nextFreeObjectNum, generationNum]);
        };
        _this.addUncompressedObjectEntry = function (byteOffset, generationNum) {
            _this.entries.push([1, byteOffset, generationNum]);
        };
        _this.addCompressedObjectEntry = function (objectStreamNum, index) {
            _this.entries.push([2, objectStreamNum, index]);
        };
        _this.encode = function () {
            _this.dictionary.set(PDFName.from('Filter'), PDFName.from('FlateDecode'));
            var buffer = new Uint8Array(_this.entriesBytesSize());
            _this.copyEntryBytesInto(buffer);
            _this.encodedEntries = pako.deflate(buffer);
            return _this;
        };
        _this.bytesSize = function () {
            _this.updateDictionary();
            return (_this.dictionary.bytesSize() +
                1 + // "\n"
                7 + // "stream\n"
                _this.contentBytesSize() +
                10 // \nendstream
            );
        };
        _this.copyBytesInto = function (buffer) {
            _this.updateDictionary();
            _this.validateDictionary();
            var remaining = _this.dictionary.copyBytesInto(buffer);
            remaining = addStringToBuffer('\nstream\n', remaining);
            if (_this.encodedEntries) {
                for (var i = 0; i < _this.encodedEntries.length; i++) {
                    remaining[i] = _this.encodedEntries[i];
                }
                remaining = remaining.subarray(_this.encodedEntries.length);
            }
            else {
                remaining = _this.copyEntryBytesInto(remaining);
            }
            remaining = addStringToBuffer('\nendstream', remaining);
            return remaining;
        };
        _this.contentBytesSize = function () {
            return _this.encodedEntries ? _this.encodedEntries.length : _this.entriesBytesSize();
        };
        _this.copyEntryBytesInto = function (buffer) {
            var entryWidths = _this.maxEntryByteWidths();
            var idx = 0;
            flatten(_this.entries).forEach(function (entry, currEntryIdx) {
                var bytes = reverseArray(bytesFor(entry));
                for (var i = entryWidths[currEntryIdx % 3] - 1; i >= 0; i--) {
                    buffer[idx++] = bytes[i] || 0;
                }
            });
            return buffer.subarray(idx);
        };
        _this.entriesBytesSize = function () {
            return sum(_this.maxEntryByteWidths()) * _this.entries.length;
        };
        _this.maxEntryByteWidths = function () { return [
            sizeInBytes(max(_this.entries.map(function (_a) {
                var x = _a[0];
                return x;
            }))),
            sizeInBytes(max(_this.entries.map(function (_a) {
                var x = _a[1];
                return x;
            }))),
            sizeInBytes(max(_this.entries.map(function (_a) {
                var x = _a[2];
                return x;
            }))),
        ]; };
        _this.updateDictionary = function () {
            _this.dictionary.set(PDFName.from('W'), PDFArray.fromArray(_this.maxEntryByteWidths().map(PDFNumber.fromNumber), _this.dictionary.index));
            _this.dictionary.set(PDFName.from('Length'), PDFNumber.fromNumber(_this.contentBytesSize()));
        };
        return _this;
    }
    PDFXRefStream.create = function (config, index) { return new PDFXRefStream(config, index); };
    return PDFXRefStream;
}(PDFStream));
export default PDFXRefStream;
