import PDFDocument from '../../pdf-document/PDFDocument';
import { PDFIndirectReference, PDFRawStream } from '../../pdf-objects';
/**
 * A note of thanks to the developers of https://github.com/devongovett/pdfkit,
 * as this class borrows heavily from:
 * https://github.com/devongovett/pdfkit/blob/e71edab0dd4657b5a767804ba86c94c58d01fbca/lib/image/jpeg.coffee
 */
declare class JPEGXObjectFactory {
    static for: (data: Uint8Array) => JPEGXObjectFactory;
    imgData: Uint8Array;
    bits: number;
    width: number;
    height: number;
    colorSpace: 'DeviceGray' | 'DeviceRGB' | 'DeviceCYMK';
    constructor(data: Uint8Array);
    embedImageIn: (document: PDFDocument) => PDFIndirectReference<PDFRawStream>;
}
export default JPEGXObjectFactory;
