import { Font } from '@pdf-lib/fontkit';
import PDFDocument from '../../pdf-document/PDFDocument';
import { PDFDictionary, PDFHexString, PDFIndirectReference } from '../../pdf-objects';
/**
 * This Factory supports embedded fonts.
 *
 * A note of thanks to the developers of https://github.com/devongovett/pdfkit,
 * as this class borrows heavily from:
 * https://github.com/devongovett/pdfkit/blob/e71edab0dd4657b5a767804ba86c94c58d01fbca/lib/font/embedded.coffee
 */
declare class PDFEmbeddedFontFactory {
    static for: (fontData: Uint8Array) => PDFEmbeddedFontFactory;
    font: Font;
    scale: number;
    fontData: Uint8Array;
    private allGlyphsInFontSortedById;
    constructor(fontData: Uint8Array);
    /**
     * Embeds the font into a [[PDFDocument]].
     *
     * @param pdfDoc A `PDFDocument` object into which the font will be embedded.
     *
     * @returns A `PDFIndirectReference` to the font dictionary that was
     *          embedded in the `PDFDocument`.
     */
    embedFontIn: (pdfDoc: PDFDocument) => PDFIndirectReference<PDFDictionary>;
    /**
     * Encode the JavaScript string into this font. JavaScript encodes strings in
     * Unicode, but embedded fonts use their own custom encodings. So this method
     * should be used to encode text before passing the encoded text to one of the
     * text showing operators, such as [[drawText]] or [[drawLinesOfText]].
     *
     * @param text The string of text to be encoded.
     *
     * @returns A `PDFHexString` of the encoded text.
     */
    encodeText: (text: string) => PDFHexString;
    /**
     * Measures the width of the JavaScript string when displayed as glyphs of
     * this font of a particular `size`.
     *
     * @param text The string of text to be measured.
     * @param size The size to be used when calculating the text's width.
     *
     * @returns A `number` representing the width of the text.
     */
    widthOfTextAtSize: (text: string, size: number) => number;
    /**
     * Measures the height of this font at a particular size. Note that the height
     * of the font is independent of the particular glyphs being displayed, so
     * this method does not accept a `text` param, like
     * [[PDFEmbeddedFontFactory.widthOfTextAtSize]] does.
     */
    heightOfFontAtSize: (size: number) => number;
    /**
     * Measures the size of this font at a particular height. Note that the size
     * of the font is independent of the particular glyphs being displayed, so
     * this method does not accept a `text` param, like
     * [[PDFEmbeddedFontFactory.widthOfTextAtSize]] does.
     */
    sizeOfFontAtHeight: (height: number) => number;
    private embedFontDictionaryIn;
    private embedCIDFontDictionaryIn;
    private embedFontDescriptorIn;
    private embedFontStreamIn;
    private embedUnicodeCmapIn;
    private deriveFontFlags;
    private deriveWidths;
}
export default PDFEmbeddedFontFactory;
