import { Font, IEncoding as IStandardEncoding, IFontNames } from '@pdf-lib/standard-fonts';
import PDFDocument from '../../pdf-document/PDFDocument';
import { PDFDictionary, PDFHexString, PDFIndirectReference } from '../../pdf-objects';
/**
 * This Factory supports Standard fonts.
 *
 * A note of thanks to the developers of https://github.com/foliojs/pdfkit,
 * as this class borrows from:
 * https://github.com/foliojs/pdfkit/blob/f91bdd61c164a72ea06be1a43dc0a412afc3925f/lib/font/afm.coffee
 */
declare class PDFStandardFontFactory {
    static for: (fontName: IFontNames) => PDFStandardFontFactory;
    font: Font;
    fontName: IFontNames;
    encoding: IStandardEncoding;
    constructor(fontName: IFontNames);
    /**
     * Embeds the font into a [[PDFDocument]].
     *
     * @param pdfDoc A `PDFDocument` object into which the font will be embedded.
     *
     * @returns A `PDFIndirectReference` to the font dictionary that was
     *          embedded in the `PDFDocument`.
     */
    embedFontIn: (pdfDoc: PDFDocument) => PDFIndirectReference<PDFDictionary>;
    /**
     * Encode the JavaScript string into this font. JavaScript encodes strings in
     * Unicode, but standard fonts use either WinAnsi, ZapfDingbats, or Symbol
     * encodings. This method should be used to encode text before passing the
     * encoded text to one of the text showing operators, such as [[drawText]] or
     * [[drawLinesOfText]].
     *
     * @param text The string of text to be encoded.
     *
     * @returns A `PDFHexString` of the encoded text.
     */
    encodeText: (text: string) => PDFHexString;
    /**
     * Measures the width of the JavaScript string when displayed as glyphs of
     * this font of a particular `size`.
     *
     * @param text The string of text to be measured.
     * @param size The size to be used when calculating the text's width.
     *
     * @returns A `number` representing the width of the text.
     */
    widthOfTextAtSize: (text: string, size: number) => number;
    /**
     * Measures the height of this font at a particular size. Note that the height
     * of the font is independent of the particular glyphs being displayed, so
     * this method does not accept a `text` param, like
     * [[PDFStandardFontFactory.widthOfTextAtSize]] does.
     */
    heightOfFontAtSize: (size: number) => number;
    /**
     * Measures the size of this font at a particular height. Note that the size
     * of the font is independent of the particular glyphs being displayed, so
     * this method does not accept a `text` param, like
     * [[PDFStandardFontFactory.widthOfTextAtSize]] does.
     */
    sizeOfFontAtHeight: (height: number) => number;
    private widthOfGlyph;
    private encodeTextAsGlyphs;
}
export default PDFStandardFontFactory;
