import flatMap from 'lodash/flatMap';
import last from 'lodash/last';
import sortBy from 'lodash/sortBy';
import { PDFArray, PDFIndirectObject, PDFName, PDFNumber, } from '../../pdf-objects';
import { PDFXRefStream, } from '../../pdf-structures';
var computeIndices = function (objectStream) {
    return objectStream.objects.map(function (object, index) { return ({
        objectNumber: object.reference.objectNumber,
        generationNumber: object.reference.generationNumber,
        index: index,
    }); });
};
var PDFXRefStreamFactory = /** @class */ (function () {
    function PDFXRefStreamFactory() {
    }
    PDFXRefStreamFactory.forOffsetsAndObjectStream = function (offsets, objectStream, catalog, index) {
        var indices = computeIndices(objectStream.pdfObject);
        var merged = sortBy(offsets.concat(indices), 'objectNumber');
        var xrefObjectNumber = last(merged).objectNumber + 1;
        var xrefStream = PDFXRefStream.create({
            Size: PDFNumber.fromNumber(xrefObjectNumber + 1),
            Root: catalog,
        }, index);
        merged.push({
            objectNumber: xrefObjectNumber,
            generationNumber: 0,
            startOffset: last(offsets).startOffset,
        });
        xrefStream.addFreeObjectEntry(0, 65535);
        var xrefSections = [{ firstObjectNumber: 0, size: 1 }];
        merged.forEach(function (obj, idx) {
            var shouldStartNewSection = idx === 0 || obj.objectNumber - merged[idx - 1].objectNumber > 1;
            if (shouldStartNewSection) {
                xrefSections.push({ firstObjectNumber: obj.objectNumber, size: 1 });
            }
            else {
                last(xrefSections).size += 1;
            }
            if ('startOffset' in obj) {
                xrefStream.addUncompressedObjectEntry(obj.startOffset, obj.generationNumber);
            }
            if ('index' in obj) {
                xrefStream.addCompressedObjectEntry(objectStream.reference.objectNumber, obj.index);
            }
        });
        xrefStream.dictionary.set(PDFName.from('Index'), PDFArray.fromArray(flatMap(xrefSections, function (_a) {
            var firstObjectNumber = _a.firstObjectNumber, size = _a.size;
            return [
                PDFNumber.fromNumber(firstObjectNumber),
                PDFNumber.fromNumber(size),
            ];
        }), index));
        xrefStream.encode();
        return PDFIndirectObject.of(xrefStream).setReferenceNumbers(xrefObjectNumber, 0);
    };
    return PDFXRefStreamFactory;
}());
export default PDFXRefStreamFactory;
