import { Entry, Subsection, Table } from '../PDFXRef';
var PDFXRefTableFactory = /** @class */ (function () {
    function PDFXRefTableFactory() {
    }
    PDFXRefTableFactory.forOffsets = function (offsets) {
        var table = new Table();
        var subsection = new Subsection().setFirstObjNum(0);
        subsection.addEntry(Entry.create()
            .setOffset(0)
            .setGenerationNum(65535)
            .setIsInUse(false));
        table.addSubsection(subsection);
        offsets.forEach(function (info, idx) {
            // Add new subsection if needed...
            var prevObjectMeta = offsets[idx - 1];
            if (idx === 0 || info.objectNumber - prevObjectMeta.objectNumber > 1) {
                subsection = new Subsection().setFirstObjNum(info.objectNumber);
                table.addSubsection(subsection);
            }
            subsection.addEntry(Entry.create()
                .setOffset(info.startOffset)
                .setGenerationNum(0)
                .setIsInUse(true));
        });
        return table;
    };
    return PDFXRefTableFactory;
}());
export default PDFXRefTableFactory;
