import { image, popGraphicsState, pushGraphicsState, rotateDegrees, rotateRadians, scale, skewDegrees, skewRadians, translate, } from '../../pdf-operators/simple';
/**
 * Draws an image object in a content stream. PNG and JPG image objects are
 * supported.
 *
 * ```javascript
 * // Should be a Uint8Array containing a PNG image
 * const pngBytes = ...
 *
 * const [pngImage, pngDims] = pdfDoc.embedPNG(pngBytes);
 * const contentStream = pdfDoc.register(
 *   pdfDoc.createContentStream(
 *     drawImage('MyPngImage', {
 *       x: 25,
 *       y: 50,
 *       width:  pngDims.width  * 0.5, // Make the image 50% smaller
 *       height: pngDims.height * 0.5, // Make the image 50% smaller
 *       rotateDegrees: 180            // Draw the image upside down
 *       skewDegrees: { xAxis: 30, yAxis: 30 } // Skew both axes by 30 degrees
 *     }),
 *   ),
 * );
 * const page = pdfDoc
 *   .createPage([250, 500])
 *   .addImageObject('MyPngImage', pngImage)
 *   .addContentStreams(contentStream);
 * ```
 *
 * @param name    Name of the image XObject to be drawn. Should be present in
 *                the XObject Dictionary of the page to which the content stream
 *                is applied.
 * @param options An options object with named parameters.
 */
export var drawImage = function (name, options) {
    return [
        pushGraphicsState(),
        translate(options.x || 0, options.y || 0),
        options.rotateDegrees && rotateDegrees(options.rotateDegrees),
        options.rotateRadians && rotateRadians(options.rotateRadians),
        scale(options.width || 100, options.height || 100),
        options.skewDegrees &&
            skewDegrees(options.skewDegrees.xAxis, options.skewDegrees.yAxis),
        options.skewRadians &&
            skewRadians(options.skewRadians.xAxis, options.skewRadians.yAxis),
        image(name),
        popGraphicsState(),
    ].filter(Boolean);
};
