import flatMap from 'lodash/flatMap';
import get from 'lodash/get';
import PDFTextObject from '../../../core/pdf-operators/text/PDFTextObject';
import { degreesToRadians, fillingRgbColor, fontAndSize, lineHeight, nextLine, rotateAndSkewTextRadiansAndTranslate, text, } from '../../pdf-operators/simple';
// TODO: Implement the border* options
/**
 * Draws a line of text in a content stream.
 *
 * ```javascript
 * const [timesRomanFont] = pdfDoc.embedStandardFont('Times-Roman');
 * const contentStream = pdfDoc.register(
 *   pdfDoc.createContentStream(
 *     drawText('This is a line of text!', {
 *       x: 25,
 *       y: 50,
 *       rotateDegrees: 180,
 *       skewDegrees: { xAxis: 15, yAxis: 15 },
 *       font: 'Times-Roman',
 *       size: 24,
 *       colorRgb: [0.25, 1.0, 0.79],
 *     }),
 *   ),
 * );
 * const page = pdfDoc
 *   .createPage([250, 500])
 *   .addFontDictionary('Times-Roman', timesRomanFont)
 *   .addContentStreams(contentStream);
 * ```
 *
 * @param line    A string of text to draw.
 * @param options An options object with named parameters.
 */
export var drawText = function (line, options) { return [
    PDFTextObject.of(fillingRgbColor(get(options, 'colorRgb[0]', 0), get(options, 'colorRgb[1]', 0), get(options, 'colorRgb[2]', 0)), fontAndSize(options.font, options.size || 12), rotateAndSkewTextRadiansAndTranslate(options.rotateDegrees
        ? degreesToRadians(options.rotateDegrees)
        : options.rotateRadians || 0, 
    // prettier-ignore
    options.skewDegrees ? degreesToRadians(options.skewDegrees.xAxis)
        : options.skewRadians ? options.skewRadians.xAxis
            : 0, 
    // prettier-ignore
    options.skewDegrees ? degreesToRadians(options.skewDegrees.yAxis)
        : options.skewRadians ? options.skewRadians.yAxis
            : 0, options.x || 0, options.y || 0), text(line)),
]; };
/**
 * Draws multiple lines of text in a content stream.
 *
 * ```javascript
 * const [timesRomanFont] = pdfDoc.embedStandardFont('Times-Roman');
 * const contentStream = pdfDoc.register(
 *   pdfDoc.createContentStream(
 *     drawLinesOfText(
 *       ['First line of text.', 'Second line of text.'], {
 *       x: 25,
 *       y: 50,
 *       rotateDegrees: 180,
 *       skewDegrees: { xAxis: 15, yAxis: 15 },
 *       font: 'Times-Roman',
 *       size: 24,
 *       lineHeight: 48,
 *       colorRgb: [0.25, 1.0, 0.79],
 *     }),
 *   ),
 * );
 * const page = pdfDoc
 *   .createPage([250, 500])
 *   .addFontDictionary('Times-Roman', timesRomanFont)
 *   .addContentStreams(contentStream);
 * ```
 *
 * @param lines   An array of strings to be drawn.
 * @param options An options object with named parameters.
 */
export var drawLinesOfText = function (lines, options) { return [
    PDFTextObject.of.apply(PDFTextObject, [fillingRgbColor(get(options, 'colorRgb[0]', 0), get(options, 'colorRgb[1]', 0), get(options, 'colorRgb[2]', 0)),
        fontAndSize(options.font, options.size || 12),
        lineHeight(options.lineHeight || options.size || 12),
        rotateAndSkewTextRadiansAndTranslate(options.rotateDegrees
            ? degreesToRadians(options.rotateDegrees)
            : options.rotateRadians || 0, 
        // prettier-ignore
        options.skewDegrees ? degreesToRadians(options.skewDegrees.xAxis)
            : options.skewRadians ? options.skewRadians.xAxis
                : 0, 
        // prettier-ignore
        options.skewDegrees ? degreesToRadians(options.skewDegrees.yAxis)
            : options.skewRadians ? options.skewRadians.yAxis
                : 0, options.x || 0, options.y || 0)].concat(flatMap(lines, function (line) { return [
        text(line),
        nextLine(),
    ]; }))),
]; };
