import { G, g } from '../../core/pdf-operators/graphics/color/GOps';
import { K, k } from '../../core/pdf-operators/graphics/color/KOps';
import { RG, rg } from '../../core/pdf-operators/graphics/color/RGOps';
import cm from '../../core/pdf-operators/graphics/graphics-state/cm';
import d from '../../core/pdf-operators/graphics/graphics-state/d';
import { J, j } from '../../core/pdf-operators/graphics/graphics-state/JOps';
import w from '../../core/pdf-operators/graphics/graphics-state/w';
import c from '../../core/pdf-operators/graphics/path-construction/c';
import l from '../../core/pdf-operators/graphics/path-construction/l';
import m from '../../core/pdf-operators/graphics/path-construction/m';
import re from '../../core/pdf-operators/graphics/path-construction/re';
import { Td } from '../../core/pdf-operators/text/text-positioning/TDOps';
import Tm from '../../core/pdf-operators/text/text-positioning/Tm';
import { Tj } from '../../core/pdf-operators/text/text-showing/TJOps';
import Tc from '../../core/pdf-operators/text/text-state/Tc';
import Tf from '../../core/pdf-operators/text/text-state/Tf';
import TL from '../../core/pdf-operators/text/text-state/TL';
import Tr from '../../core/pdf-operators/text/text-state/Tr';
import Ts from '../../core/pdf-operators/text/text-state/Ts';
import Tw from '../../core/pdf-operators/text/text-state/Tw';
import Tz from '../../core/pdf-operators/text/text-state/Tz';
import Do from '../../core/pdf-operators/Do';
import PDFOperator from '../../core/pdf-operators/PDFOperator';
import { PDFHexString, PDFName, PDFString } from '../../core/pdf-objects';
export declare const clip: () => PDFOperator;
export declare const clipEvenOdd: () => PDFOperator;
export declare const degreesToRadians: (degrees: number) => number;
export declare const translate: (xPos: number, yPos: number) => cm;
export declare const scale: (xPos: number, yPos: number) => cm;
export declare const rotateRadians: (angle: number) => cm;
export declare const rotateDegrees: (angle: number) => cm;
export declare const skewRadians: (xSkewAngle: number, ySkewAngle: number) => cm;
export declare const skewDegrees: (xSkewAngle: number, ySkewAngle: number) => cm;
export declare const dashPattern: (dashArray: number[], dashPhase: number) => d;
export declare const restoreDashPattern: () => d;
export declare const lineCap: (style: "butt" | "round" | "projecting") => J;
export declare const lineJoin: (style: "round" | "miter" | "bevel") => j;
export declare const popGraphicsState: () => PDFOperator;
export declare const pushGraphicsState: () => PDFOperator;
export declare const lineWidth: (lineWidth: number) => w;
export declare const appendBezierCurve: (x1: number, y1: number, x2: number, y2: number, x3: number, y3: number) => c;
export declare const closePath: () => PDFOperator;
export declare const moveTo: (x: number, y: number) => m;
export declare const lineTo: (x: number, y: number) => l;
export declare const rectangle: (x: number, y: number, width: number, height: number) => re;
export declare const square: (xPos: number, yPos: number, size: number) => re;
export declare const stroke: () => PDFOperator;
export declare const fill: () => PDFOperator;
export declare const fillAndStroke: () => PDFOperator;
export declare const endPath: () => PDFOperator;
export declare const nextLine: () => PDFOperator;
export declare const textPosition: (tx: number, ty: number) => Td;
export declare const text: (str: string | PDFHexString | PDFString) => Tj;
export declare const fontAndSize: (font: string | PDFName, size: number) => Tf;
export declare const charSpacing: (charSpace: number) => Tc;
export declare const wordSpacing: (wordSpace: number) => Tw;
export declare const charSqueeze: (scale: number) => Tz;
export declare const lineHeight: (leading: number) => TL;
export declare const textRise: (rise: number) => Ts;
export declare const textRenderingMode: (style: "fill" | "outline" | "fillAndOutline" | "invisible" | "fillAndClip" | "outlineAndClip" | "fillAndOutlineAndClip" | "clip") => Tr;
export declare const textMatrix: (a: number, b: number, c: number, d: number, e: number, f: number) => Tm;
export declare const rotateAndSkewTextRadiansAndTranslate: (rotationAngle: number, xSkewAngle: number, ySkewAngle: number, x: number, y: number) => Tm;
export declare const rotateAndSkewTextDegreesAndTranslate: (rotationAngle: number, xSkewAngle: number, ySkewAngle: number, x: number, y: number) => Tm;
export declare const image: (name: string | PDFName) => Do;
export declare const fillingGrayscaleColor: (gray: number) => g;
export declare const strokingGrayscaleColor: (gray: number) => G;
export declare const fillingRgbColor: (r: number, g: number, b: number) => rg;
export declare const strokingRgbColor: (r: number, g: number, b: number) => RG;
export declare const fillingCmykColor: (c: number, m: number, y: number, key: number) => k;
export declare const strokingCmykColor: (c: number, m: number, y: number, k: number) => K;
