import round from 'lodash/round';
import { G, g } from '../../core/pdf-operators/graphics/color/GOps';
import { K, k } from '../../core/pdf-operators/graphics/color/KOps';
import { RG, rg } from '../../core/pdf-operators/graphics/color/RGOps';
import cm from '../../core/pdf-operators/graphics/graphics-state/cm';
import d from '../../core/pdf-operators/graphics/graphics-state/d';
import { J, j } from '../../core/pdf-operators/graphics/graphics-state/JOps';
import w from '../../core/pdf-operators/graphics/graphics-state/w';
import c from '../../core/pdf-operators/graphics/path-construction/c';
import h from '../../core/pdf-operators/graphics/path-construction/h';
import l from '../../core/pdf-operators/graphics/path-construction/l';
import m from '../../core/pdf-operators/graphics/path-construction/m';
import re from '../../core/pdf-operators/graphics/path-construction/re';
import { Td } from '../../core/pdf-operators/text/text-positioning/TDOps';
import Tm from '../../core/pdf-operators/text/text-positioning/Tm';
import { Tj } from '../../core/pdf-operators/text/text-showing/TJOps';
import Tc from '../../core/pdf-operators/text/text-state/Tc';
import Tf from '../../core/pdf-operators/text/text-state/Tf';
import TL from '../../core/pdf-operators/text/text-state/TL';
import Tr from '../../core/pdf-operators/text/text-state/Tr';
import Ts from '../../core/pdf-operators/text/text-state/Ts';
import Tw from '../../core/pdf-operators/text/text-state/Tw';
import Tz from '../../core/pdf-operators/text/text-state/Tz';
import Do from '../../core/pdf-operators/Do';
import PDFOperators from '../../core/pdf-operators';
/* ======== Clipping path operators ======== */
var W = PDFOperators.W;
export var clip = function () { return W.operator; };
export var clipEvenOdd = function () { return W.asterisk.operator; };
/* ======== Graphics state operators ======== */
var Q = PDFOperators.Q, q = PDFOperators.q;
var cos = Math.cos, sin = Math.sin, tan = Math.tan;
export var degreesToRadians = function (degrees) { return (degrees * Math.PI) / 180; };
export var translate = function (xPos, yPos) {
    return cm.of(1, 0, 0, 1, xPos, yPos);
};
export var scale = function (xPos, yPos) {
    return cm.of(xPos, 0, 0, yPos, 0, 0);
};
// Round to the 6th decimal place to avoid JavaScript exponential notation
// being used, which starts at the 7th decimal place, e.g.
//   0.0000001 => 1e-7
//   0.000001  => 0.000001
export var rotateRadians = function (angle) {
    return cm.of(round(cos(angle), 6), round(sin(angle), 6), round(-sin(angle), 6), round(cos(angle), 6), 0, 0);
};
export var rotateDegrees = function (angle) {
    return rotateRadians(degreesToRadians(angle));
};
// Round to the 6th decimal place to avoid JavaScript exponential notation
// being used, which starts at the 7th decimal place, e.g.
//   0.0000001 => 1e-7
//   0.000001  => 0.000001
export var skewRadians = function (xSkewAngle, ySkewAngle) {
    return cm.of(1, round(tan(xSkewAngle), 6), round(tan(ySkewAngle), 6), 1, 0, 0);
};
export var skewDegrees = function (xSkewAngle, ySkewAngle) {
    return skewRadians(degreesToRadians(xSkewAngle), degreesToRadians(ySkewAngle));
};
export var dashPattern = d.of;
export var restoreDashPattern = function () { return d.of([], 0); };
export var lineCap = function (style) {
    return J.of({ butt: 0, round: 1, projecting: 2 }[style]);
};
export var lineJoin = function (style) {
    return j.of({ miter: 0, round: 1, bevel: 2 }[style]);
};
export var popGraphicsState = function () { return Q.operator; };
export var pushGraphicsState = function () { return q.operator; };
export var lineWidth = w.of;
/* ======== Path construction operators ======== */
export var appendBezierCurve = c.of;
export var closePath = function () { return h.operator; };
export var moveTo = m.of;
export var lineTo = l.of;
export var rectangle = re.of;
export var square = function (xPos, yPos, size) {
    return rectangle(xPos, yPos, size, size);
};
/* ======== Path painting operators ======== */
var S = PDFOperators.S, f = PDFOperators.f, B = PDFOperators.B, n = PDFOperators.n;
export var stroke = function () { return S.operator; };
export var fill = function () { return f.operator; };
export var fillAndStroke = function () { return B.operator; };
export var endPath = function () { return n.operator; };
/* ======== Test positioning operators ======== */
var T = PDFOperators.T;
// TODO: Allow an optional number to move more/less than the default line height.
export var nextLine = function () { return T.asterisk.operator; };
export var textPosition = Td.of;
/* ======== Text showing operators ======== */
export var text = Tj.of;
/* ======== Text state operators ======== */
export var fontAndSize = Tf.of;
export var charSpacing = Tc.of;
export var wordSpacing = Tw.of;
// Compresses glyphs horizontally - not vertically.
export var charSqueeze = Tz.of;
export var lineHeight = TL.of;
export var textRise = Ts.of;
export var textRenderingMode = function (style) {
    return Tr.of({
        fill: 0,
        outline: 1,
        fillAndOutline: 2,
        invisible: 3,
        fillAndClip: 4,
        outlineAndClip: 5,
        fillAndOutlineAndClip: 6,
        clip: 7,
    }[style]);
};
export var textMatrix = Tm.of;
// Round to the 6th decimal place to avoid JavaScript exponential notation
// being used, which starts at the 7th decimal place, e.g.
//   0.0000001 => 1e-7
//   0.000001  => 0.000001
export var rotateAndSkewTextRadiansAndTranslate = function (rotationAngle, xSkewAngle, ySkewAngle, x, y) {
    return Tm.of(round(cos(rotationAngle), 6), round(sin(rotationAngle) + tan(xSkewAngle), 6), round(-sin(rotationAngle) + tan(ySkewAngle), 6), round(cos(rotationAngle), 6), x, y);
};
export var rotateAndSkewTextDegreesAndTranslate = function (rotationAngle, xSkewAngle, ySkewAngle, x, y) {
    return rotateAndSkewTextRadiansAndTranslate(degreesToRadians(rotationAngle), degreesToRadians(xSkewAngle), degreesToRadians(ySkewAngle), x, y);
};
/* ======== XObject operator ======== */
export var image = Do.of;
/* ======== Color operators ======== */
export var fillingGrayscaleColor = g.of;
export var strokingGrayscaleColor = G.of;
export var fillingRgbColor = rg.of;
export var strokingRgbColor = RG.of;
export var fillingCmykColor = k.of;
export var strokingCmykColor = K.of;
