/* tslint:disable:ban-types */
import forEach from 'lodash/forEach';
// Need this for React Native Android.
// Need to import the minified version because it is ES5 not ES6 - which is
// required to us "uglify" for minification.
import 'proxy-polyfill/proxy.min.js'; // Need this for React Native Android
import { isInstance, validate } from './validate';
var EMPTY_ARR = [];
// TODO: See if this can be refined/simplified at all...
export var typedArrayProxy = function (obj, type, config) {
    if (config === void 0) { config = {}; }
    forEach(config.methods, function (val, key) {
        obj[key] = new Proxy(obj[key], {
            apply: function (target, thisArg, elements) {
                return val(function (args) { return target.apply(thisArg, args); }, elements);
            },
        });
    });
    return new Proxy(obj, {
        set: function (target, property, value, receiver) {
            if (!(property in EMPTY_ARR)) {
                validate(value, isInstance(type), "Typed Array Proxy elements must be of type " + type.name);
            }
            if (config.set)
                config.set(property, value);
            target[property] = value;
            return true;
        },
        get: function (target, property, receiver) {
            if (config.get && config.get(property)) {
                return config.get(property)(target[property]);
            }
            return target[property];
        },
    });
};
