import { Predicate } from '.';
export declare const validate: <T>(value: T, predicate: (t: T) => boolean, msg: string) => void;
export declare const optional: <T>(predicate: Predicate<T, true>) => (value: any) => boolean;
export declare const validateArr: <T extends any[]>(value: T, predicate: (t: T[0]) => boolean, msg: string) => void;
export declare const isInstance: <T extends Function>(requiredClass: T) => (value: any) => boolean;
export declare const isArrayOf: <T extends Function>(requiredClass: T) => (value: any) => boolean;
export declare const isIdentity: <T>(requiredValue: T) => (value: any) => boolean;
export declare const isNotIdentity: <T>(requiredValue: T) => (value: any) => boolean;
export declare const doesMatch: (regex: RegExp) => (value: string) => boolean;
export declare const isNumber: (n: any) => boolean;
export declare const isInRange: (lower: number, upper: number) => (value: any) => boolean;
export declare const isIndirectObjectOf: <T extends Function>(requiredClass: T) => (value: any) => boolean;
export declare const oneOf: <T>(...allowed: T[]) => (value: any) => boolean;
