/* tslint:disable:ban-types */
import inRange from 'lodash/inRange';
import isArray from 'lodash/isArray';
import isNaN from 'lodash/isNaN';
import isNil from 'lodash/isNil';
import _isNumber from 'lodash/isNumber';
import { PDFIndirectObject } from '../core/pdf-objects';
import { and, not } from '.';
export var validate = function (value, predicate, msg) {
    if (!predicate(value))
        throw new Error(msg);
};
export var optional = function (predicate) { return function (value) {
    return isNil(value) || predicate(value);
}; };
export var validateArr = function (value, predicate, msg) {
    validate(value, isArray, 'validateArr.value must be an array.');
    value.forEach(function (v) { return validate(v, predicate, msg); });
};
export var isInstance = function (requiredClass) { return function (value) { return value instanceof requiredClass; }; };
export var isArrayOf = function (requiredClass) { return function (value) {
    if (!isArray(value))
        return false;
    for (var i = 0; i < value.length; i++) {
        if (!(value[i] instanceof requiredClass))
            return false;
    }
    return true;
}; };
export var isIdentity = function (requiredValue) { return function (value) {
    return value === requiredValue;
}; };
export var isNotIdentity = function (requiredValue) { return function (value) {
    return value !== requiredValue;
}; };
export var doesMatch = function (regex) { return function (value) {
    return !!value.match(regex);
}; };
export var isNumber = function (n) { return and(_isNumber, not(isNaN))(n); };
export var isInRange = function (lower, upper) { return function (value) {
    return inRange(value, lower, upper) || value === upper;
}; };
export var isIndirectObjectOf = function (requiredClass) { return function (value) {
    return isInstance(PDFIndirectObject)(value) &&
        isInstance(requiredClass)(value.pdfObject);
}; };
export var oneOf = function () {
    var allowed = [];
    for (var _i = 0; _i < arguments.length; _i++) {
        allowed[_i] = arguments[_i];
    }
    return function (value) {
        return allowed.some(function (a) { return a === value; });
    };
};
