import { PDFDocument } from '../pdf-document';
declare class PDFDocumentWriter {
    /**
     * Converts a [[PDFDocument]] object into the raw bytes of a PDF document.
     * These raw bytes could, for example, be saved as a file and opened in a
     * PDF reader.
     *
     * `options.useObjectStreams` controls whether or not to use Object Streams
     * when saving the document. Using Object Streams will result in a smaller
     * file size for many documents. This option is `true` by default. If set to
     * `false`, then Object Streams will not be used.
     *
     * @param pdfDoc  The [[PDFDocument]] to be converted to bytes.
     * @param options An options object.
     *
     * @returns A `Uint8Array` containing the raw bytes of a PDF document.
     */
    static saveToBytes: (pdfDoc: PDFDocument, options?: {
        useObjectStreams: boolean;
    }) => Uint8Array;
    private static saveToBytesWithXRefTable;
    private static saveToBytesWithObjectStreams;
}
export default PDFDocumentWriter;
