"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var pdf_objects_1 = require("../pdf-objects");
var utils_1 = require("../../utils");
var validate_1 = require("../../utils/validate");
var PDFObjectIndex = /** @class */ (function () {
    function PDFObjectIndex() {
        var _this = this;
        this.index = new Map();
        this.highestObjectNumber = -1;
        this.assign = function (key, val) {
            validate_1.validate(key, validate_1.isInstance(pdf_objects_1.PDFIndirectReference), '"key" must be a PDFIndirectReference');
            validate_1.validate(val, validate_1.isInstance(pdf_objects_1.PDFObject), '"val" must be a PDFObject');
            if (key.objectNumber > _this.highestObjectNumber) {
                _this.highestObjectNumber = key.objectNumber;
            }
            _this.index.set(key, val);
            return _this;
        };
        this.nextObjectNumber = function () {
            _this.highestObjectNumber += 1;
            var ref = pdf_objects_1.PDFIndirectReference.forNumbers(_this.highestObjectNumber, 0);
            return ref;
        };
        this.assignNextObjectNumberTo = function (val) {
            var ref = _this.nextObjectNumber();
            _this.assign(ref, val);
            return ref;
        };
        this.lookupMaybe = function (ref) {
            if (ref instanceof pdf_objects_1.PDFIndirectReference)
                return _this.index.get(ref);
            return ref;
        };
        this.lookup = function (ref) {
            return _this.lookupMaybe(ref) || utils_1.error("Failed to lookup ref: " + ref);
        };
    }
    PDFObjectIndex.create = function () { return new PDFObjectIndex(); };
    return PDFObjectIndex;
}());
exports.default = PDFObjectIndex;
