"use strict";
var __extends = (this && this.__extends) || (function () {
    var extendStatics = Object.setPrototypeOf ||
        ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
        function (d, b) { for (var p in b) if (b.hasOwnProperty(p)) d[p] = b[p]; };
    return function (d, b) {
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
}
Object.defineProperty(exports, "__esModule", { value: true });
var add_1 = __importDefault(require("lodash/add"));
var isNumber_1 = __importDefault(require("lodash/isNumber"));
var utils_1 = require("../../utils");
var validate_1 = require("../../utils/validate");
var PDFObjectIndex_1 = __importDefault(require("../pdf-document/PDFObjectIndex"));
var _1 = require(".");
var PDFObject_1 = __importDefault(require("./PDFObject"));
var PDFArray = /** @class */ (function (_super) {
    __extends(PDFArray, _super);
    function PDFArray(array, index) {
        var _this = _super.call(this) || this;
        _this.push = function () {
            var val = [];
            for (var _i = 0; _i < arguments.length; _i++) {
                val[_i] = arguments[_i];
            }
            validate_1.validateArr(val, validate_1.isInstance(PDFObject_1.default), 'PDFArray.push() requires arguments to be PDFObjects');
            (_a = _this.array).push.apply(_a, val);
            return _this;
            var _a;
        };
        _this.set = function (idx, val) {
            validate_1.validate(idx, isNumber_1.default, 'PDFArray.set() requires indexes to be numbers');
            validate_1.validate(val, validate_1.isInstance(PDFObject_1.default), 'PDFArray.set() requires values to be PDFObjects');
            _this.array[idx] = val;
            return _this;
        };
        _this.get = function (idx) {
            validate_1.validate(idx, isNumber_1.default, 'PDFArray.get() requires indexes to be numbers');
            return _this.array[idx];
        };
        _this.forEach = function (fn) {
            return _this.array.forEach(fn);
        };
        _this.map = function (fn) {
            return _this.array.map(fn);
        };
        _this.splice = function (start, deleteCount) {
            return _this.array.splice(start, deleteCount);
        };
        _this.clone = function () { return PDFArray.fromArray(_this.array.slice(), _this.index); };
        _this.toString = function () {
            var bufferSize = _this.bytesSize();
            var buffer = new Uint8Array(bufferSize);
            _this.copyBytesInto(buffer);
            return utils_1.arrayToString(buffer);
        };
        _this.bytesSize = function () {
            return 2 + // "[ "
                _this.array
                    .map(function (e) {
                    if (e instanceof _1.PDFIndirectObject)
                        return e.toReference().length + 1;
                    else if (e instanceof PDFObject_1.default)
                        return e.bytesSize() + 1;
                    return utils_1.error("Not a PDFObject: " + e);
                })
                    .reduce(add_1.default, 0) +
                1;
        }; // "]";
        _this.copyBytesInto = function (buffer) {
            var remaining = utils_1.addStringToBuffer('[ ', buffer);
            _this.array.forEach(function (e, idx) {
                if (e instanceof _1.PDFIndirectObject) {
                    remaining = utils_1.addStringToBuffer(e.toReference(), remaining);
                }
                else if (e instanceof PDFObject_1.default) {
                    remaining = e.copyBytesInto(remaining);
                }
                else {
                    utils_1.error("Not a PDFObject: " + e);
                }
                remaining = utils_1.addStringToBuffer(' ', remaining);
            });
            remaining = utils_1.addStringToBuffer(']', remaining);
            return remaining;
        };
        _this.size = function () { return _this.array.length; };
        validate_1.validateArr(array, validate_1.isInstance(PDFObject_1.default), 'Cannot construct PDFArray from array whose elements are not PDFObjects');
        validate_1.validate(index, validate_1.isInstance(PDFObjectIndex_1.default), '"index" must be a an instance of PDFObjectIndex');
        _this.array = array;
        _this.index = index;
        return _this;
    }
    PDFArray.fromArray = function (array, index) {
        return new PDFArray(array, index);
    };
    return PDFArray;
}(PDFObject_1.default));
exports.default = PDFArray;
